/**
 *
 * @author John Rayworth
 * International School of Prague
 * jrayworth@isp.cz
 */

package _Text_Book;

import java.io.BufferedReader; 
import java.io.IOException;
import java.io.InputStreamReader;


public class Error_Messages_Examples {

    //MISSING CLOSE BRACE
    //1. Try taking away any close brace.
    
    //MISSING OPEN BRACE
    //2. Try taking away any open brace, other than the one for the class, which is pretty obvious anyway.
    //And you will get *****multiple***** errors, for this issue only.
    
    
    //IMPORT ISSUES, LIKE WITH BUFFEREDREADER LINE
    //3. Try commenting out the line above: import java.io.BufferedReader;
    static BufferedReader br = new BufferedReader(new InputStreamReader(System.in));

    public static void main(String[] args) throws IOException {
        
        //DECLARATION OF VARIABLES 
        int myInt = 3; //4. Try taking away the int.
        int myOtherInt = 4; //5. Try taking away the ;
        int anotherNumber = 5; //6. Try changing the integer 5 to be the real number 5.0.

        
        
        //FOR LOOPS
        for (int i = 0; i < 10; i++){
            System.out.println("hello world");
        }
        //7. Above, try removing one of the semi-colons, or changing them to a a colon instead.
        //8. Above, try taking away the "int"

        
        
        //WHILE LOOPS
        long startTime = System.currentTimeMillis();
        while(System.currentTimeMillis() < startTime + 2){
            System.out.println("Still under 2 milliseconds running.");
        }
        //9. Try removing the "< startTime + 2"
        //10. Try removing the open brace {
        //11. Try removing the close brace }
        
        
        
        //CONDITIONAL BLOCKS
        boolean b1 = true;
        if (b1){ //12. Try removing this brace.
            System.out.println("The variable b must be true.");
        } //13. Try removing this brace.
        else { //14. Try removing this brace.
            System.out.println("The variable b must be false.");
        } //15. Try removing this brace.
        
        int x = 1;
        int y = 2;
        int z = 3;
        if(x == y){ //16. Try changing the == to =.
            System.out.println("x is equal to y.");
        }else{
            System.out.println("x is not equal to y.");
        }
        
        
        
        //INPUT FROM CONSOLE (KEYBOARD)
        System.out.println("What is your name?");
        String name = br.readLine(); //17. Try taking away the static in the BufferedReader line way above.
        //18. Try taking away the "throws IOException" in the main method header way above.
        System.out.println("Do you like pizza? true/false");
        boolean likesPizza = Boolean.parseBoolean(br.readLine());
        //19. Try taking away the Boolean.parseBoolean and last close parentheses).
        //20. Try taking away one of the close parentheses ).
        
        
        
        //METHOD CALLING
        aMethod1(); //21. Try changing the name of the called method from aMethod1 to aMethod2.
        anotherMethod("hello", 5); //22. Try changing the order of these two parameters to be 5, "hello".
        //23. Try adding in another parameter, like another number.
        
        
        
        //ARRAYS
        String [] myStringArray = new String[10];
        //24. Try taking away the 10.
        //25. Try taking away the first "[]".
        //26. Try taking away the "new" operator.
        
        
        
        //VARIOUS BRACES ISSUES
        //27. Try taking away various close braces.
        
    }
    
    public static void aMethod1(){
        System.out.println("This is from within the method callee aMethod1.");
    }
    
    public static void anotherMethod(String s, int n){
        for(int i = 0; i < n; i++){
            System.out.println(s);
        }
    }
}

/*

Common Error Messages As Displayed by Netbeans 7.x

Usage Instructions: Copy and paste the error message into a Find field of this document, and possibly Find Again until you locate the message and solution.



MISSING CLOSE BRACE

1. illegal start of expression

This means - almost always - that some block of code above does not have a close brace.
Solution: check all open/close brace pairs, by clicking on each open brace, and looking for the matching yellow-highlighted close brace to see if it's the proper one.



MISSING OPEN BRACE

2. *****Multiple error messages*****

This is usually due to the absence of an open brace some place.

Solution: check all open/close brace pairs, by clicking on each open brace, and looking for the matching yellow-highlighted close brace to see if it's the proper one.



IMPORT ISSUES, LIKE WITH BUFFEREDREADER LINE

3. cannot find symbol
	symbol: Class sdfasfasdasd
	location: class_Adssfasdfa_LKjkljljjk_Asdfsfd
	
- No import of certain packages, like java.io.BufferedReader
Solution: Click on the lightbulb for that line of code if there is one.



DECLARATION OF VARIABLES

4. cannot find symbol
	symbol: variable sdfasfsda
	location: classAsasfd_Ljslfsdjsd_Asdfsadfas

- The variable is not properly defined, probably because you didn't declare its data type.
Solution: Put the data type before the variable name, such as:
int myInt = 3;


5. ';' expected

- This is exactly what it says.
Solution: Put a semi-colon at the end of the line. All statements in Java (though not block headings) require a semi-colon to end them. So:
int myOtherInt = 4;


6. possible loss of precision
	required: int
	found:    double

- In this case you are trying to assign a "larger" number type to a "smaller" number type, 
for example trying to assign a double (a real number; i.e. one with a fractional part) to an int.
Solution: Either take away the decimal portion of the number, or change the variable being assigned to be a double, for example. So:
int anotherInt = 5;
or
double anotherNumber = 5.0;



FOR LOOPS

7. ';' expected  (in a for loop statement)

- Same as 3 above, only this one from within a for statement.
You can think of the three parts of the for statement condition as being a line each, so they are separated by semi-colons.


8.  cannot find symbol
	symbol: variable i
	location: class Asfsdsdf_Ljslfsdjsd_Asdfsadfas

- Same as 2 above, only this one from with a for statement. 
You do still have to declare the type of the loop control variable (i) you are using.



WHILE LOOPS

9. incompatible types
 	 required: boolean
 	 found:    long

- The expression inside the parentheses following "while" must evaluate, ultimately, to the boolean true or false. When you take away the comparison part, you are left just with a number, not true or false.
Solution: make sure what is inside the parentheses of the while statement evaluates to true or false.


10. illegal start of type

	<identifier> expected

In the context of a while loop above this error, the open parentheses of the while block is missing.
Solution: make sure all brace pairs are correct.


11. illegal start of expression

- In the context of a wile loop problem, it means the close brace was forgotten.
Solution; make sure all brace pairs are correct. Even possibly way above where this error occurs.



CONDITIONAL BLOCKS

12. illegal start of type

- A brace missing some lines above.
Solution: check all of your pairs of braces for a missing partner. Click on the braces one at a time, and they and their present "partner" will be highlighted yellow; you'll see when a certain open brace is mis-matched with a close brace.


13. 'else' without 'if'

- The if block above an else block has a missing end brace.
Solution: check all pairs of braces for the missing one.


14. class, interface, or enum expected

- If the problem is within a conditional block, it's the lack of an open brace in one of the else if blocks.
Solution: check all pairs of braces for the missing one.


15. reached end of file while parsing

- If the problem is within a conditional block, it's the lack of a close brace in one of the else if blocks.
Solution: check all pairs of braces for missing one.


16. incompatible types
	required: boolean
	found:    int

- Here, the idea is that within the parentheses of an if condition, the expression must ultimately evaluate down to a boolean value of true or false. 
In this case, what has happened is you used a single = rather than a double ==. What you intended to do is compare the equality between two numbers, in which case you should use the equality operator ==, but you used the = assignment operator, in which case, one number was assigned the value of the other number, meaning the that expression evaluates to a number, not a boolean.
Solution: change the = to ==, or whatever makes the expression ultimately a boolean expression.



INPUT FROM CONSOLE (KEYBOARD)

17. non-static variable sadfasdfas cannont be references from a static context

- If this is from a statement trying to take in some user input using the br object, it means that the br object was not declared as being static, yet you are within a method which is static, such as the main method.
Solution: find where you did your BufferedReader etc. line, and type "static" in front of it.


18. unreported exception java.io.IOException; must be caught or declared to be thrown

- Java demands that you "handle" all potential errors that could happen, and taking in input from the keyboard is a time when errors can happen, so you have to either use a "try/catch" block around attempts to get input from the keyboard, or have the method in which you put it "throw" an exception.
Solution: click on the lightbulb and take the first suggestion. (Or do it yourself by adding a "throws IO Exception" at the end of the main method heading.)


19. incompatible types
	required: boolean
	found:    java.lang.String

- In this case you want to have a value which is some type other than String, but the br.readLine() line will return only a String. 
Solution: so you have to use one of the "wrapper class" methods to "parse" the returned String into the type you want. Such as, for a boolean:
boolean likesPizza = Boolean.parseBoolean(br.readLine());


22. ')' expected

- In the case of a method call like readLine(), you just need to have both the open and the close parentheses following that method call.
Solution: make sure all open parentheses are matched up with a close parentheses.



METHOD CALLING

21. ')' expected

- In the context of a "readLine()" line, you're missing the second close parenthesis for the line, keeping in mind that you need to close both the readLine method's parentheses pair, and also the parseBoolean, for example, method's parenthesis pair.


22. cannot find symbol
   	symbol:   method aMethod2()
  	location: class Asdfasdsadf_Jsfdsdfds_Ssfdsfddfs

- This means that there is no method called what you wrote. 
Solution: create the method if you did not already, or correct the spelling and capitalization to be the same as the method you created.


23. method anotherMethod in class _Asdfasdsadf_Jsfdsdfds_Ssfdsfddfs cannot be applied to given types;
	required: java.lang.String,int
	found: int,java.lang.String
  	reason: actual argument int cannot be converted to java.lang.String by method invocation conversion

- This is a case of sending the wrong order of the parameters. A String, followed by an int was required, but the order you sent them in was wrong - in this case an int followed by a String.
Solution: make sure the order and number of parameters you are sending to the method is correct.


24. method anotherMethod in class Asdfasdsadf_Jsfdsdfds_Ssfdsfddfs cannot be applied to given types;
	required: java.lang.String,int
	found: java.lang.String,int,int
	reason: actual and formal argument lists differ in length

- The same idea as above, but this time, you will have sent the wrong number of parameters.
Solution: make sure the order and number of parameters you are sending to the method is correct.



ARRAYS

25. array dimension missing

- You declared an array the "new" operator way, but forgot to include the size of the array.
Solution: Put a number between the second [ ] of the declaration, like:
String [] myStringArray = new String[10];

26. incompatible types
  	required: java.lang.String
  	found:    java.lang.String[]

- Within the context of declaring an array, you forgot the first [ ].
Solution: make sure on the left hand side of the assignment operator you have an empty set of [ ], like:
String [] myStringArray = new String[10];

27. cannot find symbol
  	symbol:   variable String
  	location: class Asfsdasdf_Jljkjljlj_Dsfasddasfd

- Within the context of declaring an array the "new" operator way, you forgot the new operator.
Solution: put the word "new" in the correct place, like:
String [] myStringArray = new String[10];
*/